/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8237;

import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.modelgen.ConfigChangeDetector;
import ibm.nways.jdm.modelgen.LocalModel;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Vector;

public class HubChangeDetector
implements ConfigChangeDetector {
    private static int maxhubs = 10;
    private static int cfgvars = 4;
    private static int hubType;
    private static int femType;
    private static int hOrder;
    private static int segNum;
    private static final int RASID = 19;
    private static final int RASSUB = 29;
    int[][] oldHubs = new int[maxhubs][cfgvars];
    int[][] newHubs = new int[maxhubs][cfgvars];
    LocalModel hubModel;
    LocalModel femModel;

    public int[][] cfginfo(LocalModel localModel) {
        int[][] nArray = new int[maxhubs][cfgvars];
        try {
            Object object;
            Object object2;
            if (this.hubModel == null) {
                object2 = localModel.getComponent("ConfigurationFolder");
                if (object2 == null) {
                    return nArray;
                }
                object = ((LocalModel)object2).getComponent("SystemFolder");
                if (object == null) {
                    return nArray;
                }
                LocalModel localModel2 = ((LocalModel)object).getComponent("DeviceFolder");
                if (localModel2 == null) {
                    return nArray;
                }
                LocalModel localModel3 = localModel2.getComponent("HubFolder");
                if (localModel3 == null) {
                    return nArray;
                }
                if (this.hubModel == null) {
                    this.hubModel = localModel3.getComponent("BasicHub");
                    this.femModel = localModel3.getComponent("BasicFem");
                }
                if (this.hubModel == null) {
                    return nArray;
                }
            }
            object2 = this.hubModel.getRestOfInfo("BasicHubConfig", "default", null, null);
            object = this.femModel.getRestOfInfo("BasicFemConfig", "default", null, null);
            if (object2 == null) {
                return nArray;
            }
            int n = ((Vector)object2).size();
            int n2 = 0;
            while (n2 < n) {
                ModelInfo modelInfo = (ModelInfo)((Vector)object2).elementAt(n2);
                ModelInfo modelInfo2 = (ModelInfo)((Vector)object).elementAt(n2);
                Serializable serializable = modelInfo.get("Index.UnitIdNumber");
                if (serializable instanceof SpecialValue) {
                    return nArray;
                }
                int n3 = (Integer)serializable;
                nArray[n3 - 1][HubChangeDetector.hubType] = (Integer)modelInfo.get("BasicHubConfig.BasicHubType");
                nArray[n3 - 1][HubChangeDetector.femType] = (Integer)modelInfo2.get("BasicFemConfig.BasicFemType");
                nArray[n3 - 1][HubChangeDetector.hOrder] = (Integer)modelInfo.get("BasicHubConfig.BasicHubPosition");
                nArray[n3 - 1][HubChangeDetector.segNum] = (Integer)modelInfo.get("BasicHubConfig.BasicHubSegment");
                ++n2;
            }
        }
        catch (Exception exception) {
            RAS.logError(19, 29, this, "cfginfo", "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"BasicHub", (Object)"Jdm8237Model");
            RAS.logException(19, 29, this, "cfginfo", exception);
        }
        return nArray;
    }

    public void init(LocalModel localModel) {
        this.oldHubs = this.cfginfo(localModel);
    }

    public boolean configChanged(LocalModel localModel) {
        int n = 0;
        while (n < maxhubs && this.oldHubs[n][hOrder] == 0) {
            ++n;
        }
        if (n == maxhubs) {
            this.init(localModel);
            if (RAS.isEnabled(19, 29)) {
                RAS.trace(19, 29, this, "configChanged", "need to init oldHubs");
            }
            return false;
        }
        this.newHubs = this.cfginfo(localModel);
        int n2 = 0;
        while (n2 < maxhubs) {
            int n3 = 0;
            while (n3 < cfgvars) {
                if (this.newHubs[n2][n3] != this.oldHubs[n2][n3]) {
                    if (RAS.isEnabled(19, 29)) {
                        RAS.trace(19, 29, this, "configChanged", "detected a change in the stack");
                    }
                    this.oldHubs = this.newHubs;
                    return true;
                }
                ++n3;
            }
            ++n2;
        }
        return false;
    }

    public void dispose() {
        int n = 0;
        while (n < maxhubs) {
            this.oldHubs[n][0] = 0;
            ++n;
        }
        this.hubModel.dispose();
        this.hubModel = null;
        this.femModel.dispose();
        this.femModel = null;
    }

    static {
        femType = 1;
        hOrder = 2;
        segNum = 3;
    }
}

